function [beta_star]=iBinding_2FHeston_MA_noise(par,coeffs,nintra,ndays,nrepl,invVCV,D,ss,W);

beta=zeros(rows(coeffs),nrepl);
M = nintra;
T = ndays;
P0=100;

kappa_1=(par(1));
kappa_2=(par(2));
omega=(par(3));
eta_1=(par(4));
eta_2=(par(5));
sigma_nu=par(6);
phi=par(7);

params=[kappa_1,kappa_2,omega,eta_1,eta_2,phi];
sampling=60;

parfor j=1:nrepl;
     w=W(:,:,j);
    [r,v_l,v_s]=simulate_heston_two_factors(T,M,params,1,w(:,1),w(:,2),w(:,3),w(:,4),ss+j);
   u=w(:,5)*sqrt(sigma_nu);
    noise=[0;phi*u(1:end-1)+u(2:end)];
    nu=reshape(noise,nintra,ndays);
    p=log(P0)+cumsum(reshape(r/100,nintra*ndays,1));
    %p_tilde=p+noise/100;
    r_n=r+nu;%reshape([0;diff(p_tilde)],M,T)*100;
    RV_5_sec=sum(r_n.^2)';
    p_D=reshape(p(1:sampling:end),nintra/sampling,ndays);
    r_D=reshape([zeros(1,ndays);diff(p_D)],nintra/sampling,ndays)*100+nu(1:sampling:end,:);
    RV_5_min=sum(r_D.^2)';
    freq=[1,5,22];
    result1=HAR(log(RV_5_sec),[],freq,1);
    result2=HAR(log(RV_5_min),[],freq,1);
    Omega=cov([result1.resid,result2.resid]);
    beta_hat=[result1.beta;result2.beta;vech(Omega)];
    beta(:,j)=beta_hat;
end;
    beta_star=mean(beta')';


